function [cdata] = prop_sum2(filename,pathname,idx)
%A stupid little function that will open up some AT lists from find_imgprop
%remove the outliers and write out a new file with some math.  Differ from
%prop_sum in that all the properties are in one file not multiple files.
%(each columns = a property)
%Synatax:   [cdata] = prop_sum2(); 
%Input:     idx = the location of the index property.  default = 2
%           filename_tmp = the files to be summarized
%           pathname = the path of the files
%Output:    cdata = the array of results from the math applied to data.

if nargin==0
    %open the index file: the file where the outliers are to be found
    [filename_tmp,pathname,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open CSV','Multiselect','on');
    %make sure filename is a cell array
    if ~iscell(filename_tmp)
        filename{1,1} = filename_tmp;
    else
        filename = filename_tmp;
    end
end

%now open up the data files, and concatenate them.
for i = 1:size(filename,2)
    data_tmp = [];
    %read the file
    try     %make sure the file has data
        data_tmp = dlmread([pathname,filename{1,i}],',',1,0);
    end
    if ~isempty(data_tmp)       %move on only if there is data 
        %now remove our NaN
        data_tmp(isnan(data_tmp(:,1)),:) = [];
        if ~isempty(data_tmp)  %check again
            if nargin<3     %the idx is not entered
                idx = sum(data_tmp(:,:));    %grab the first few point for a little test, we pick 5, because changes low that all 5 are not deci
                idx_int = round(idx);   %convert to integer, the size meteric should be the only integer in the lot
                idx_tmp = idx==idx_int;     %where is the int?
                idx_tmp = idx_tmp+(nanmedian(data_tmp,1)<500);   %intensity measurements are huge
                idx_tmp = idx_tmp+(idx~=0);     %cannot be zero, size that is
                idx = find(idx_tmp==3);     %find it, meet all criteria, done
                if size(idx,2)>1    %the wild case where the two made it through
                    idx = 2;    %default only really works for me really
                    display(['prop_sum: Too many index found','data_tmp median: ',num2str(median(data_tmp,1)),' idx_tmp: ',num2str(idx_tmp)]);
                elseif isempty(idx)     %another unlikely case, but
                    idx = 2;    %default
                    display(['prop_sum: No index found. ','data_tmp median: ',num2str(median(data_tmp,1)),' idx_tmp: ',num2str(idx_tmp)]);
                end
            end
            
            %now find the outliers and remove the data
            %first calculate our criteria
            out = median(data_tmp(:,idx))+std(data_tmp(:,idx))*3;     %3 times the standard deviation should do it.
            [x,y] = find(data_tmp(:,idx)>out);        %find the outliers.
            data_tmp(x,:) = [];             %remove the outlier
            
            %do some math on the data
            cdata(1,:) = mean(data_tmp,1);
            cdata(2,:) = std(data_tmp,1);
            cdata(3,:) = repmat(size(data_tmp,1),1,size(data_tmp,2));
            cdata(4,:) = median(data_tmp,1);
            
            %localization for macs
            if ispc
                slash = '\';        %Windows directory marker
            else
                slash = '/';        %Mac directory marker
            end
            
            %now save the data
            csv_exp = dataset(data_tmp);               %to export as a CSV need to make the data a dataset.
            export(csv_exp,'File',[[pathname(1,1:end-1),slash],'data_',filename{1,i}(1:end-4),'_',num2str(size(data_tmp,1)),'.csv'],'delimiter',',')
            csv_exp = dataset(cdata);               %to export as a CSV need to make the data a dataset.
            export(csv_exp,'File',[[pathname(1,1:end-1),slash],'sum_',filename{1,i}(1:end-4),'.csv'],'delimiter',',')
        end
    end
end
